function [ut t G c]= timedec13(tk,  Omega,method, R, C, htext_msg)
%timedec13.m
%Anmo Kim
%Jan. 4th, 2009
%time decoding machine for 4d hodgkin-huxley neuron
%using project-integrate-and-fire concept, or phase response curve
%prc is varying based upon the current inter-spike interval

%tk : sequence of spike timings
%Omega : the bandwidth of u(t); i.e. $u(t) \in PW(\Omega)$
%method : 'riemann' - computing integral with Riemann sum
%         'quad' - use 'adaptive Simpson quadrature' method for
%                  computing integral
%         if nothing designated, 'quad' is to be used




%initialization part ------------------------------------------------------
ut=[]; t=[]; G=[]; Ginv=[];




if(nargin<3)
   warn6('timedec13: wrong input argumnents\n u = timedec13(sk,  Omega, a, algorithm)', htext_msg);
   return;
end


if(nargin==4)
   method='quad';
elseif(~strcmpi(method,'riemann'))
   method='quad';
end


load hohu4dIbaseprc.mat
%Ibase, isi, dt, prc
dt0=dt*10^-3;
prc0=prc*10^-3;
Ibase0=Ibase;

dt = pi/Omega/2000; % 2000 samples per a zero-to-zero interval of g(.)



prc=interp1((0:(size(prc0,2)-1))*dt0, prc0', 0:dt:(size(prc0,2)*dt0-dt0),'spline');
isik=(isi/dt/1000);


%sk = (tk(1:(end-1))+tk(2:end))./2;
sk=linspace((tk(2)+tk(1))./2, (tk(end)+tk(end-1))/2, ceil(pi/Omega/max(diff(tk(2:end))))*ceil(Omega/pi*(tk(end)-tk(1))));


t=(tk(1)-3*pi/Omega):dt:(tk(end)+3*pi/Omega);
lent=length(t);


if(strcmp(method,'quad'))
%use 'adaptive Simpson quadrature' method for
%                  computing integral

warn6('timedec13:simpson quadrature integration not implemented yet', htext_msg);

else
   t0 = t(1):dt:(2*tk(end)-tk(1)+3*pi/Omega+1);
   gsk0 = sinc(Omega./pi.*(t0-sk(end))).*Omega./pi; %g(sk(end))
  
   
   ti = round((tk-t0(1))/dt)+1;
    si=round((sk-t0(1))/dt)+1;  
   for l=1:(length(tk)-1)
       starti=ti(l)+si(end)+1;
       endi=ti(l+1)+si(end);
%        if(l==1)
%            prcisi=ti(2)-ti(1);
%        else
           prcisi=ti(l+1)-ti(l);%the previous one - because of the hysterisis.
       %end
       
       if( ti(l+1)-ti(l)-0.0001/dt>=isik(1))
           q=Ibase0(1);
       elseif(ti(l+1)-ti(l)-0.0001/dt<isik(end))
            q=Ibase0(end);
       else
           q=interp1(isik, Ibase0, ti(l+1)-ti(l)-0.0001/dt);
       end
           
       prcisi=interp1(Ibase0,isik,q);
       %linear interpolation
       nextk=find(isik<=prcisi,1,'first');
       if(isempty(nextk))
           prc7=prc(:,end);
           delta(l+1)=sum(prc7)*dt*q+(prcisi-(t(end)-t(end-1)))*dt;
       elseif(nextk==1)
           prc7=prc(:,1);
           delta(l+1)=sum(prc7)*dt*q+(prcisi-(t(2)-t(1)))*dt;
       else
           prc7=(isik(nextk-1)-prcisi)/(isik(nextk-1)-isik(nextk))*prc(:,nextk-1)...
               +(prcisi-isik(nextk))/(isik(nextk-1)-isik(nextk))*prc(:,nextk);
           
          delta(l+1)=sum(prc7)*dt*q+0.0001;
       end

       if(length(prc7)>=ti(l+1)-ti(l))
           prc8=prc7(1:(ti(l+1)-ti(l)))';
       else
           prc8=[ zeros(1,ti(l+1)-ti(l)-length(prc7)) prc7'];
       end
      
      for k=1:length(si)
         G(l,k)=sum(gsk0((starti-si(k)):(endi-si(k))).*prc8)*dt;
%          figure(1);subplot(211);plot(gsk0((starti-si(k)):(endi-si(k))));subplot(212);plot(prc8);
%         drawnow;
      end

   end
   Ginv = pinv(G); %Moore-penrose pseudo inverse matrix
   

   c = Ginv*delta(2:end)';
   
%   c = sum(Ginv,2).* (C*delta);

   ut=zeros(size(t));
   
   for k=1:length(si)
      ut = ut +c(k).*gsk0((1:length(t))+si(end)-si(k));
   end
end

%ut=ut*10^(12);%A-->pA
% gsk3 = repmat(gsk, [1 1 length(sk)]);
% 
% 
% onoff=zeros([1 size(gsk,2) size(gsk,1)]);
% for k=1:length(sk)
%   onoff(1, (round(tk(k)/dt):round(tk(k+1)/dt)), k)=1;
% end
% 
% onoff3 = repmat(onoff, [length(sk) 1 1]);



%display warning either on matlab command prompt or on text_msg gui control
function warn6(s,htext_msg)
if(nargin<1) return; end
if(isempty(s)) return; end

if(nargin<2)
   warn6(s,htext_msg);
   return;
end

if(isempty(htext_msg))
   warn6(s,htext_msg);
   return;
end

if(ishandle(htext_msg))
   set(htext_msg, 'String',s);
else
   warn6(s,htext_msg);
end